<?php

namespace Dealerdirect\Sdk\Model\Email;

use Dealerdirect\Sdk\Model\Email\Substitution\AbstractSubstitution;

final class Email
{
    /** @return string */
    private $locale;
    /** @return string */
    private $vehicleType;
    /** @return string */
    private $emailType;
    /** @return array */
    private $substitution = [];

    /** @return string */
    public function getLocale()
    {
        return $this->locale;
    }

    /** @return string */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    /** @return string */
    public function getEmailType()
    {
        return $this->emailType;
    }

    /** @return array*/
    public function getSubstitution()
    {
        return $this->substitution;
    }

    public function __construct($locale, $vehicleType, $emailType, AbstractSubstitution $substitution)
    {
        $this->emailType = $emailType;
        $this->locale = $locale;
        $this->vehicleType = $vehicleType;
        $this->substitution = $substitution->toArray();
    }
}
