<?php

namespace DealerDirect\Sdk;

use Dealerdirect\EmailServiceSdk;
use DealerDirect\Sdk\Client\HttpClient;
use DealerDirect\Sdk\Facade\BrokerageAgreement;
use DealerDirect\Sdk\Facade\Email;
use GuzzleHttp\Client;

class Sdk
{
    /** @var BrokerageAgreement */
    private $brokerageAgreement;
    /** @var Config */
    private $config;
    /** @var Email */
    private $email;

    /**
     * @return BrokerageAgreement
     */
    public function getBrokerageAgreement()
    {
        // @CHECKME: Shouldn't fetching the URL be moved into the `if` statement?   2017/06/13/BMP
        $url = $this->config->get(Config::BROKERAGE_AGREEMENT_URL);

        if ($this->brokerageAgreement === null) {
            // @TODO: The logic to create a BrokerageAgreement Facade should be moved to a factory  2017/06/13/BMP
            $config = [
                'base_url' => $url
            ];

            $client = new Client($config);

            /*/ Disable SSL until test and accept boxes have proper certificates /*/
            // @FIXME: This needs to be wrapped in a is-dev-environment-check
            $client->setDefaultOption('verify', false);
            $client->setDefaultOption('exceptions', false);

            $consumerAPI = new HttpClient($client);

            $this->brokerageAgreement = new BrokerageAgreement($consumerAPI);
        }

        return $this->brokerageAgreement;
    }

    /**
     * @return Email
     */
    public function getEmail()
    {
        if ($this->email === null) {
            // @TODO: The logic to create an Email Facade should be moved to a factory  2017/06/13/BMP

            $config = new EmailServiceSdk\Configuration();

            $config->setHost($this->config->get(Config::EMAIL_SERVICE_URL));

            $apiClient =new EmailServiceSdk\ApiClient($config);

            $sendEmailApi = new EmailServiceSdk\Api\SendEmailApi($apiClient);

            $this->email = new Email($sendEmailApi);
        }

        return $this->email;
    }

    public function __construct(Config $config)
    {
        $this->config = $config;
    }
}
/*EOF*/
