<?php

namespace DealerDirect\Sdk\Client;

use GuzzleHttp\Client as GuzzleClient;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Message\ResponseInterface;
use Psr\Http\Message\UriInterface;

/**
 * Proxy/Facade for GuzzleHttp\Client
 *
 * @method ResponseInterface delete(string|UriInterface $uri, array $options = [])
 * @method ResponseInterface get(string|UriInterface $uri, array $options = [])
 * @method ResponseInterface head(string|UriInterface $uri, array $options = [])
 * @method ResponseInterface patch(string|UriInterface $uri, array $options = [])
 * @method ResponseInterface post(string|UriInterface $uri, array $options = [])
 * @method ResponseInterface put(string|UriInterface $uri, array $options = [])
 */
class HttpClient /* sort-of implements https://raw.githubusercontent.com/guzzle/guzzle/master/src/ClientInterface.php */
{
    const DELETE = 'DELETE';
    const GET = 'GET';
    const HEAD = 'HEAD';
    const PATCH = 'PATCH';
    const POST = 'POST';
    const PUT = 'PUT';

    /** @var GuzzleClient */
    private $guzzleClient;
    /** @var string */
    private $url;

    final public function __construct(GuzzleClient $guzzleClient, $url = '')
    {
        $this->guzzleClient = $guzzleClient;
        $this->url = $url;
    }

    /**
     * Create and send an HTTP request.
     *
     * Use an absolute path to override the base path of the client, or a
     * relative path to append to the base path of the client. The URL can
     * contain the query string as well.
     *
     * @param string              $method  HTTP method.
     * @param string|UriInterface $uri     URI object or string.
     * @param array               $options Request options to apply.
     *
     * @return ResponseInterface
     *
     * @throws \LogicException When the handler does not populate a response
     * @throws RequestException When an error is encountered
     */
    final public function request($method, $uri, array $options = [])
    {
        $httpClient = $this->guzzleClient;

        $url = $this->url.$uri;

        $request = $httpClient->createRequest($method, $url, $options);

        return $httpClient->send($request);
    }

    final public function __call($name, $arguments)
    {
        $availableMethods = ['delete', 'get', 'head', 'patch', 'post', 'put',];

        $guzzleClient = $this->guzzleClient;

        if (in_array($name, $availableMethods, true) === false) {
            throw new \BadMethodCallException(
                sprintf('Call to undefined method %s::%s()', __CLASS__, $name)
            );
        } else {
            return $guzzleClient->$name($arguments);
        }
    }
}

/*EOF*/
