<?php

namespace DealerDirect\Sdk;

use DealerDirect\Sdk\Exception\ConfigException;

class Config
{
    /* @NOTE: This is the key of the BrokerageAgreement API URL in the .env file */
    const BROKERAGE_AGREEMENT_KEY = 'DEALERDIRECT_BROKERAGE_API_URL';

    const ERROR_GET_BEFORE_SET = 'Can not get value "%s" before it has been set';
    const ERROR_WRONG_TYPE = 'Given value "%s" of type "%s" is not %s';

    /** @var array */
    private $config = [];

    /**
     * @return Config
     *
     * @throws ConfigException
     */
    public static function fromEnv()
    {
        $config = new Config();

        $config->setBrokerageAgreementApiUrl(getenv(self::BROKERAGE_AGREEMENT_KEY));

        return $config;
    }

    /**
     * @return string
     *
     * @throws ConfigException
     */
    public function getBrokerageAgreementApiUrl()
    {
        if (array_key_exists(self::BROKERAGE_AGREEMENT_KEY, $this->config) === false) {
            throw new ConfigException(
                sprintf(
                    self::ERROR_GET_BEFORE_SET,
                    self::BROKERAGE_AGREEMENT_KEY
                )
            );
        }
        return $this->config[self::BROKERAGE_AGREEMENT_KEY];
    }

    /**
     * @param string $url
     *
     * @throws ConfigException
     */
    public function setBrokerageAgreementApiUrl($url)
    {
        // @TODO: Validate $url is actually an URL ?
        if (is_string($url) === false) {
            throw new ConfigException(
                sprintf(
                    self::ERROR_WRONG_TYPE,
                    $url,
                    gettype($url),
                    'a valid URL string'
                )
            );
        }

        $this->config[self::BROKERAGE_AGREEMENT_KEY] = $url;
    }
}