<?php

namespace DealerDirect\Sdk;

use DealerDirect\Sdk\Client\HttpClient;
use DealerDirect\Sdk\Facade\BrokerageAgreement;
use GuzzleHttp\Client;

class Sdk
{
    /** @var BrokerageAgreement */
    private $brokerageAgreement;
    /** @var Config */
    private $config;

    function __construct(Config $config)
    {
        $this->config = $config;
    }

    public function getBrokerageAgreement()
    {
        $url = $this->config->getBrokerageAgreementApiUrl();

        if ($this->brokerageAgreement === null) {

            $config = [
                'base_url' => $url
            ];

            $client = new Client($config);

            /*/ Disable SSL until test and accept boxes have proper certificates /*/
            // @FIXME: This needs to be wrapped in a is-dev-environment-check
            $client->setDefaultOption('verify', false);
            $client->setDefaultOption('exceptions', false);

            $consumerAPI = new HttpClient($client);

            $this->brokerageAgreement = new BrokerageAgreement($consumerAPI);
        }

        return $this->brokerageAgreement;
    }
}
/*EOF*/
