![Dealerdirect SDK Logo](docs/logo.png)

# Dealerdirect SDK

 > Meta package and facade for all API's (SOAP, REST, etc.) used by various Dealerdirect applications.

## Introduction

This package contains facade/proxy classes for internal API's. 

As part of the cleanup, applications and services should not call other services 
directly but should use the classes provided by this package instead. That way, 
when things get cleaned up it is easier to switch to other endpoints. 

An example of this is switching from email calls in "the SOAP API" to calling 
the Email Service instead.

Currently this package contains facades for:

- ?

## Installation

The preferred means of installing this code is by adding it as a Composer 
dependency to a project. This is done by adding this repository as a requirement. 

Add the following section to a project's `composer.json`: 

    {
        "…": "…",
        "repositories": [
            {
                "type": "git",
                "url": "git@bitbucket.org:dealerdirect/dealerdirect-sdk.git"
            }
        ]
    }

Then require the package:

    composer require --sort-packages dealerdirect/sdk

## Usage

The overall usage scenario is:

1. create an SDK object
2. Retrieve a Facade/Proxy from the SDK object
3. Make calls to the retrieved Facade/Proxy
4. ????
5. PROFIT!!!

In code that would look something like this:

    <?php
    
    namespace DealerDirect\Example\Sdk;
    
    use DealerDirect\Sdk\Sdk;

    require dirname(__DIR__) . '/vendor/autoload.php';
    
    $sdk = new Sdk();

    $proxyOrFacade = $sdk->getSomeProxyOrFacade();

    $result = $proxyOrFacade->aCallToTheProxiedService();
    
    // Do something with $result


The [`examples`](./examples) directory contains more detailed examples for each 
of the calls for each Proxy/Facade. 

## Development

Instead of adding facades per service, facades should be added per responsibility. 

Facades that still need to be added are:

- Email
- Consumer
- Dealer

There is still a debate whether or not other packages (like PDF and Generic) 
should be added to applications directly or should also be part of this package.

When adding a new facade the following steps need to be taken:

1. Add a class to the `src/Facade` directory
2. Add a getter to the `DealerDirect\Sdk\Sdk` class for the facade
3. Add calls to the facade class
4. Add examples
5. Update documentation

To keep things organized, it is okay to add sub-facades in sub-directories and 
delegate calls.

Don't forget to add a git tag to bump the package's version.
