<?php

namespace DealerDirect\Sdk;

use Dealerdirect\EmailServiceSdk;
use DealerDirect\Sdk\Facade\Email;

class Sdk
{
    /** @var Config */
    private $config;
    /** @var Email */
    private $email;

    /**
     * @return Email
     */
    public function getEmail()
    {
        if ($this->email === null) {
            // @TODO: The logic to create an Email Facade should be moved to a factory  2017/06/13/BMP

            $config = new EmailServiceSdk\Configuration();

            $config->setHost($this->config->get(Config::EMAIL_SERVICE_URL));

            $config->addDefaultHeader('X-Caller-Host', isset($_SERVER['SERVER_NAME'])?$_SERVER['SERVER_NAME']:'cli');
            $debug = debug_backtrace(false, 4);
            $caller = end($debug);
            $msg = sprintf("%s:%s",
                isset($caller['file'])?$caller['file']:'unknown-file',
                isset($caller['function'])?$caller['function']:'unknown-function'
            );
            $config->addDefaultHeader('X-Caller-file', $msg);

            $apiClient = new EmailServiceSdk\ApiClient($config);

            $sendEmailApi = new EmailServiceSdk\Api\SendEmailApi($apiClient);

            $this->email = new Email($sendEmailApi);
        }

        return $this->email;
    }

    public function __construct(Config $config)
    {
        $this->config = $config;
    }
}
