<?php

namespace Tests;

use Vonage\Client;
use Vonage\SMS\SentSMS;
use Dealerdirect\SMS\SMS;
use Vonage\SMS\Collection;
use PHPUnit\Framework\TestCase;
use Vonage\SMS\Client as SMSClient;
use Vonage\Client\Credentials\Basic;
use Dealerdirect\SMS\Messages\Message;
use Vonage\SMS\Message\SMS as SmsMessage;
use Dealerdirect\SMS\Exceptions\SmsException;

/**
 * TODO: Add more tests
 */
class SMSTest extends TestCase
{
    /**
     * @covers Dealerdirect\SMS\SMS::send Dealerdirect\SMS\SMS::findMobileAndFormat
     */
    public function testSendSmsWithoutMobilePhoneNumberShouldThrowException()
    {
        $this->expectException(SmsException::class);
        $this->expectExceptionMessage("Could not find a mobile number in [+31534341424, 0534341424]");

        $sms = new SMS($this->fixtureGetClient(), $this->fixtureGetMessage());
        $sms->send(['+31534341424', '0534341424']);
    }

    /**
     * @covers Dealerdirect\SMS\SMS::send Dealerdirect\SMS\SMS::findMobileAndFormat
     *
     * @return void
     */
    public function testSendSmsWithValidMobileNumberFromOtherCountry()
    {
        $expectedMessage = new SmsMessage('+32498223963', '', '');

        $smsClient = $this->fixtureGetSmsClient();
        $smsClient->expects($this->once())
            ->method('send')
            ->with($this->equalTo($expectedMessage))
            ->willReturn($this->fixtureGetSmsResponse());

        $sms = new SMS($this->fixtureGetClient($smsClient), $this->fixtureGetMessage());
        $sendnr = $sms->send(['1223423424', '+32498223963']);
        self::assertEquals('+32498223963', $sendnr);
    }

    /**
     * @covers Dealerdirect\SMS\SMS::send Dealerdirect\SMS\Exceptions\SmsException::class
     */
    public function testClientRequestExceptionShouldThrowSmsException()
    {
        $this->expectException(SmsException::class);

        $sms = new SMS(new Client(new Basic('key', 'secret')), $this->fixtureGetMessage());
        $sms->send(['+31612345678']);
    }

    /**
     * @covers Dealerdirect\SMS\SMS::send Dealerdirect\SMS\Exceptions\SmsException::class
     */
    public function testSendSmsShouldThrowSmsExceptionOnStatusNotEqualToZero()
    {
        $this->expectException(SmsException::class);

        $sentSms = $this->createStub(SentSMS::class);
        $sentSms->method('getStatus')->willReturn(1);

        $smsResponse = $this->fixtureGetSmsResponse(true);
        $smsResponse->method('current')->willReturn($sentSms);

        $smsClient = $this->fixtureGetSmsClient();
        $smsClient->method('send')->willReturn($smsResponse);

        $sms = new SMS($this->fixtureGetClient($smsClient), $this->fixtureGetMessage());
        $sms->send(['+31612345678']);
    }

    /**
     * @param SMSClient $smsClient
     * @return Client
     */
    public function fixtureGetClient($smsClient = null)
    {
        $client = $this->createStub(Client::class);
        $client->method('__call')
            ->with('sms')
            ->willReturn($smsClient ?? $this->fixtureGetSmsClient());

        return $client;
    }

    public function fixtureGetSmsResponse(bool $valid = true)
    {
        $smsResponse = $this->createStub(Collection::class);
        $smsResponse->method('valid')->willReturn($valid);

        return $smsResponse;
    }

    /**
     * @return SMSClient
     */
    public function fixtureGetSmsClient()
    {
        return $this->createStub(SMSClient::class);
    }

    /**
     * @return Message
     */
    public function fixtureGetMessage()
    {
        return $this->createStub(Message::class);
    }
}
