<?php

namespace Dealerdirect\SMS\Messages;

use Dealerdirect\SMS\Helper;
use Dealerdirect\SMS\Messages\Traits\Getters;

class PhotoUpload implements Message
{
    use Getters;

    private $branch;
    private $data;

    /**
     * @inheritDoc
     */
    public function __construct(string $vehicleType, string $country, array $data)
    {
        $this->vehicleType = $vehicleType;
        $this->country = $country;
        $this->branch = strtolower("{$this->vehicleType}_{$this->country}");

        Helper::validateData(['name', 'url', 'sender'], $data);

        $this->sender = Helper::pullFromArray($data, 'sender');
        $this->data = $data;
    }

    /**
     * @inheritDoc
     */
    public function getContent(): string
    {
        $contents = [
            'car_nl' => <<<TXT
Beste %s, voeg foto's toe via %s om je aanmelding volledig te maken. Groet ikwilvanmijnautoaf
TXT,
            'car_be' => <<<TXT
Beste %s, voeg foto\'s toe via %s om uw aanmelding volledig te maken. Met vriendelijke groeten ikwilvanmijnautoaf
TXT,
            'motorbike_nl' => <<<TXT
Beste %s, voeg foto\'s toe via %s om je aanmelding volledig te maken. Groet ikwilvanmijnmotoraf
TXT,
            'motorbike_be' => <<<TXT
Beste %s, voeg foto\'s toe via %s om uw aanmelding volledig te maken. Met vriendelijke groeten ikwilvanmijnmotoraf
TXT,
            'motorbike_de' => <<<TXT
Hallo %s, bitte fügen Sie Bilder hinzu über %s um Ihre Anmeldung zu vervollständigen. Viele Grüsse
ichwillmeinmotorradloswerden
TXT,
            'scooter_nl' => <<<TXT
Beste %s, voeg foto\'s toe via %s om je aanmelding volledig te maken. Groet ikwilvanmijnscooteraf
TXT,
        ];

        Helper::validateBranch($this->branch, $contents);

        return sprintf($contents[$this->branch], $this->data['name'], $this->data['url']);
    }
}
