<?php

namespace Dealerdirect\SMS\Messages;

interface Message
{
    /**
     * Message constructor
     *
     * @param string $vehicleType
     * @param string $country
     * @param array $data
     */
    public function __construct(string $vehicleType, string $country, array $data);

    /**
     * Gets message content, based on vehicleType and country
     *
     * @return string The content of SMS
     * @throws \Excpetion
     */
    public function getContent(): string;

    /**
     * Gets the sender for current sms, can be a name or number.
     *
     * @return string
     * @throws \Excpetion
     */
    public function getSender(): string;

    /**
     * Gets current country.
     *
     * @return string
     */
    public function getCountry(): string;

    /**
     * Gets current vehicleType
     *
     * @return string
     */
    public function getVehicleType(): string;
}
