<?php

namespace Dealerdirect\SMS\Exceptions;

class MessageException extends Exception
{
    public static function missingAttributes(array $errors)
    {
        $errors = implode(', ', $errors);

        return new self("Missing required attributes: [$errors]");
    }

    public static function invalidBranch($branch, array $available)
    {
        $available = self::implodeKeys($available);

        return new self("Invalid branch '{$branch}'. Available branches: [$available]");
    }

    public static function invalidCountry($country, array $available)
    {
        $available = self::implodeKeys($available);

        return new self("Invalid country '{$country}'. Available countries: [$available]");
    }
}
