<?php

namespace Dealerdirect\SMS\Exceptions;

use Throwable;
use Vonage\SMS\Collection;

class SmsException extends Exception
{
    public static function request(Throwable $exception): self
    {
        return new self("SMS request error with message '{$exception->getMessage()}'", 0, $exception);
    }

    public static function noMobileNumber($phoneNumbers)
    {
        $phoneNumbers = implode(', ', $phoneNumbers);

        return new self("Could not find a mobile number in [$phoneNumbers]");
    }

    public static function invalidResponse()
    {
        return new self("Invalid SMS response");
    }

    public static function invalidStatus($status)
    {
        return new self("Invalid status response '$status'. See: https://developer.nexmo.com/api-errors/sms");
    }
}
