<?php

namespace Dealerdirect\VehicleClassification;

use Dealerdirect\VehicleClassification\Models\Vehicle;

class VehicleClassificationHelper
{
    private $mapping = null;

    public function __construct()
    {
        $this->mapping = include(__DIR__ . "/VehicleCallGroupIdMapping.php");
    }

    /**
     * This should be done later by the database but because it is not sure if
     * this code will be live forever we will map the values here.
     *
     * @param int $classifiedGroupId
     * @param string $countryCode
     * @return int
     */
    public function getCallGroupIdByClassifiedGroupId($classifiedGroupId = 0, $countryCode = 'NL')
    {
        // We randomly choose a callgroup (NOT SO RANDOM!!!)
        $currentCallgroup = $this->mapping[$classifiedGroupId][$countryCode];
        $callGroupId = $currentCallgroup[array_rand($currentCallgroup)];

        return (int)$callGroupId;
    }

    /**
     * @param int $originVehicleSite
     * @param int $bodyWorkId
     *
     * @return int
     */
    public function getVehicleTypeByBodyWork($originVehicleSite, $bodyWorkId)
    {
        switch ($originVehicleSite) {
            case Vehicle::TYPE_MOTOR:
                switch ($bodyWorkId) {
                    case 9: //Scooter
                    case 16: //Snorfiets
                    case 17: //Bromfiets
                        $vehicleType = Vehicle::TYPE_SCOOTER;
                        break;
                    default:
                        $vehicleType = Vehicle::TYPE_MOTOR;
                }
                break;
            case Vehicle::TYPE_CAR:
                switch ($bodyWorkId) {
                    case 14: //Camper
                    case 15: //Caravan
                    case 17: //Vouwwagen
                        $vehicleType = Vehicle::TYPE_RECREATIONAL;
                        break;
                    case 12: //Bestelwagen enkele cabine
                    case 13: //Bestelwagen dubbele cabine
                    case 16: //Aanhanger
                    case 21: //Personenbus
                        $vehicleType = Vehicle::TYPE_TRANSPORT;
                        break;
                    case 18: //45-km Brommobiel
                        $vehicleType = Vehicle::TYPE_UNKNOWN;
                        break;
                    default:
                        $vehicleType = Vehicle::TYPE_CAR;
                        break;
                }
                break;
            default:
                $vehicleType = Vehicle::TYPE_UNKNOWN;
                break;
        }


        return $vehicleType;
    }

    /**
     * @param int $bodyWorkId
     *
     * @return int
     */
    public function getNumberOfDoorsByBodyWork($bodyWorkId)
    {
        switch ($bodyWorkId) {
            case 1:
            case 8:
            case 9:
            case 10:
                $result = 3;
                break;
            case 2:
                $result = 4;
                break;
            case 4: // can be 3 or 5 but after conversation with sefa he rather has 5
            case 7:
            case 3:
                $result = 5;
                break;
            case 18:
            case 19:
            case 20:
                $result = 2;
                break;
            default:
                $result = 0;
                break;
        }

        return $result;
    }

    /**
     * @param string $comment
     * @param string $site
     *
     * @return bool
     */
    public function getDrivableMotorByComment($comment, $site)
    {
        $result = true;
        switch ($site) {
            case 'WWW.ICHWILLMEINMOTORRADLOSWERDEN.DE':
                $checks = [
                    0 => 'Ist das Motorrad fahrtüchtig?: Nein',
                    1 => 'Ist das Motorrad fahrtüchtig?: Ja',
                ];
                break;
            case 'WWW.JEVOUDRAISVENDREMAMOTO.BE':
            case 'JEVOUDRAISVENDREMAMOTO.FR':
                $checks = [
                    0 => 'Le véhicule est-il mobile?: Non',
                    1 => 'Le véhicule est-il mobile?: Oui',
                ];
                break;
            default:
                $checks = [
                    0 => 'Start de motor?: Nee',
                    1 => 'Start de motor?: Ja',
                ];
                break;
        }

        foreach ($checks as $value => $check) {
            if (strpos($comment, $check) !== false) {
                $result = (bool) $value;
            }
        }

        return $result;
    }
}
