<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Operator;
use Ruler\Rule;

class GroupPremiumClassicRules extends GroupPremiumRules implements GroupRulesInterface
{

    public function __construct()
    {
        $currentYear = (int)date('Y');

        // NOTE: For now we check exclusive makes his way:
        // This list was created subjectively!
        $this->premiumMakesModels = array(
            'ASTON MARTIN',
            'BENTLEY',
            'BUGATTI',
            'CADILLAC',
            'FERRARI',
            'HUMMER',
            'JAGUAR',
            'LAMBORGHINI',
            'MCLAREN',
            'MASERATI',
            'MAYBACH',
            'PAGANI',
            'PORSCHE',
            'ROLLS-ROYCE',
            'SPYKER'
        );

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::lessThan('yearOfManufacture', $currentYear - 16),
                    ConditionUtils::isOneOf('makeName', $this->premiumMakesModels)
                )),
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::lessThan('yearOfManufacture', $currentYear - 25),
                    new Operator\LogicalOr(array(
                        ConditionUtils::greaterThanOrEqualTo('actualValue', 2500),
                        ConditionUtils::greaterThanOrEqualTo('askingPrice', 4000)
                    ))
                ))
            ))
        );
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_PREMIUM_CLASSIC_ID;
    }
}
