<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Operator;
use Ruler\Rule;

class GroupPremiumExclusiveRules extends GroupPremiumRules implements GroupRulesInterface
{

    public function __construct()
    {
        $currentYear = (int)date('Y');

        // NOTE: For now we check exclusive makes his way:
        // This list was created subjectively!
        $this->premiumMakesModels = array(
            'ASTON MARTIN',
            'BENTLEY',
            'BUGATTI',
            'CADILLAC',
            'FERRARI',
            'HUMMER',
            'JAGUAR',
            'LAMBORGHINI',
            'MCLAREN',
            'MASERATI',
            'MAYBACH',
            'PAGANI',
            'PORSCHE',
            'ROLLS-ROYCE',
            'SPYKER'
        );

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                // Premium Exclusive models, > year 2001
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::greaterThanOrEqualTo('yearOfManufacture', $currentYear - 16),
                    ConditionUtils::isOneOf('makeName', $this->premiumMakesModels)
                )),
                // Listprice > 100K, > year 2001
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::greaterThanOrEqualTo('yearOfManufacture', $currentYear - 16),
                    ConditionUtils::greaterThanOrEqualTo('listPrice', 100000)
                ))
            ))
        );
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_PREMIUM_EXCLUSIVE_ID;
    }
}
