<?php

namespace DealerDirect\VehicleClassification\Rules;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\Cars\GroupDemolitionRules;
use Ruler\Context;

class GroupDemolitionRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test Demolition group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupDemolition
     */
    public function testGroupDemolitionCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupDemolitionRules = new GroupDemolitionRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupDemolitionRules->evaluate($context));
    }

    /**
     * Test Demolition group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupDemolition
     */
    public function testGroupDemolitionWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupDemolitionRules = new GroupDemolitionRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupDemolitionRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupDemolition()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 204000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 1999,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 200,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'makeName' => 'PEUGEOT',
                'modelName' => '206',
                'fuelType' => 'benzine',
                'mileage' => '15000',
                'yearOfManufacture' => 2006,
                'bpm' => '2729',
                'con_carrosserie' => '3',
                'damageFree' => '0',
                'driveable' => '1',
                'askingPrice' => 450,
                'actualValue' => 250,
                'carrosserie' => '1',
                'uitvoering' => '206 Gentry 1.4',
                'motorinhoud' => '1360'
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupDemolition()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 155000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 2002,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 500,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'makeName' => 'PEUGEOT',
                'modelName' => '206',
                'fuelType' => 'benzine',
                'mileage' => '15000',
                'yearOfManufacture' => 2003,
                'bpm' => '2729',
                'con_carrosserie' => '3',
                'damageFree' => '0',
                'driveable' => '1',
                'askingPrice' => 450,
                'actualValue' => 250,
                'carrosserie' => '1',
                'uitvoering' => '206 Gentry 1.4',
                'motorinhoud' => '1360'
            )),
        );
    }
}
