<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\FuelUtils;
use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupPremiumClassicRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test PremiumClassic group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupPremiumClassic
     */
    public function testGroupPremiumClassicCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupPremiumClassicRules = new GroupPremiumClassicRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupPremiumClassicRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupPremiumClassic
     */
    public function testGroupPremiumClassicWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupPremiumClassicRules = new GroupPremiumClassicRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupPremiumClassicRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupPremiumClassic()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 144000,
                'makeName' => 'VOLKSWAGEN',
                'modelName' => 'GOLF GTI',
                'yearOfManufacture' => 1979,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 15000,
                'actualValue' => 10000,
                'numberOfDoors' => 2
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 77000,
                'makeName' => 'FORD',
                'modelName' => 'MUSTANG',
                'yearOfManufacture' => 1966,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 39000,
                'actualValue' => 40000,
                'numberOfDoors' => 2
            )),
            //"Exclusive classic"
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 44000,
                'makeName' => 'PORSCHE',
                'modelName' => '911 TURBO',
                'yearOfManufacture' => 1986,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 0,
                'askingPrice' => 72000,
                'listPrice' => 100000,
                'numberOfDoors' => 2
            )),
            // "Young timer"
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 86000,
                'makeName' => 'PORSCHE',
                'modelName' => 'CARRERA',
                'yearOfManufacture' => 1999,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 8000,
                'askingPrice' => 65000,
                'listPrice' => 89000,
                'numberOfDoors' => 2
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupPremiumClassic()
    {
        return array(
            array(array(
                'vehicleType' => 'car',
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 155000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 2015,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 30000,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => 'car',
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 190000,
                'makeName' => 'SKODA',
                'modelName' => 'SUPERB',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '8284',
                'askingPrice' => 17000,
                'numberOfDoors' => 3
            )),
            array(array(
                'vehicleType' => 'car',
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 56500,
                'makeName' => 'PORSCHE',
                'modelName' => '911 TURBO',
                'yearOfManufacture' => 2002,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 80000,
                'listPrice' => 120000,
                'numberOfDoors' => 2
            )),
        );
    }
}
