<?php

namespace DealerDirect\VehicleClassification\Utils;

use Ruler\Context;
use Ruler\Rule;

/**
 * Condition util class Unit tests
 *
 * @package DealerDirect\VehicleClassification\Utils
 */
class ConditionTest extends \PHPUnit_Framework_TestCase
{

    public function testEqualTo()
    {
        $rule = new Rule(
            ConditionUtils::equalTo('damageFree', true)
        );

        $context = new Context(
            array(
                'damageFree' => '1',
            )
        );

        $evaluationResult = $rule->evaluate($context);

        $this->assertTrue($evaluationResult);
    }

    public function testHasAllValues()
    {
        $rule = new Rule(
            ConditionUtils::hasValues(
                'options',
                array(
                    2, 4, 7, 8
                )
            )
        );

        $context = new Context(
            array(
                'options' => array(
                    1, 2, 3, 4, 5, 6, 7, 8, 9, 10
                )
            )
        );

        $evaluationResult = $rule->evaluate($context);

        $this->assertTrue($evaluationResult);
    }

    public function testDoesNotHaveAllValues()
    {
        $rule = new Rule(
            ConditionUtils::hasValues(
                'options',
                array(
                    4, 7, 8, 11, 12, 13
                )
            )
        );

        $context = new Context(
            array(
                'options' => array(
                    1, 2, 3, 4, 5, 6, 7, 8, 9, 10
                )
            )
        );

        $evaluationResult = $rule->evaluate($context);

        $this->assertFalse($evaluationResult);
    }



    public function testHasMoreValuesThanRequired()
    {


        $rule = new Rule(
            ConditionUtils::hasValues(
                'options',
                array(
                    2, 4, 7, 8
                )
            )
        );

        $context = new Context(
            array(
                'options' => array(
                    2, 3, 4, 5, 6, 7, 8, 9

                )
            )
        );

        $evaluationResult = $rule->evaluate($context);

        $this->assertTrue($evaluationResult);
    }

}
