<?php

use Dealerdirect\VehicleClassification\Rules\Cars\RuleSet as CarRuleSet;
use Dealerdirect\VehicleClassification\Rules\Motors\RuleSet as MotorRuleSet;

return array(
    // Rules by ticket DEV-2634
    CarRuleSet::GROUP_NO_ID => array(
        // countryCode => callgroupIds
        'NL' => array(950),
        'BE' => array(951),
        'BE-FR' => array(952),
        'DE' => array(953),
    ),
    CarRuleSet::GROUP_DEMOLITION_ID => array(
        'NL' => array(2),
        'BE' => array(12),
        'BE-FR' => array(967),
        'DE' => array(62),
    ),
    CarRuleSet::GROUP_EXPORT_ID => array(
        'NL' => array(7),
        'BE' => array(17),
        'BE-FR' => array(967),
        'DE' => array(67),
    ),
    CarRuleSet::GROUP_HIGH_ID => array(
        'NL' => array(8),
        'BE' => array(18),
        'BE-FR' => array(967),
        'DE' => array(65),
    ),
    CarRuleSet::GROUP_YOUNG_ID => array(
        'NL' => array(1),
        'BE' => array(11),
        'BE-FR' => array(967),
        'DE' => array(61),
    ),
    CarRuleSet::GROUP_LOW_ID => array(
        'NL' => array(5),
        'BE' => array(15),
        'BE-FR' => array(967),
        'DE' => array(66),
    ),
    CarRuleSet::GROUP_PREMIUM_EXCLUSIVE_ID => array(
        'NL' => array(78),
        'BE' => array(13),
        'BE-FR' => array(967),
        'DE' => array(63),
    ),
    CarRuleSet::GROUP_PREMIUM_CLASSIC_ID => array(
        'NL' => array(69),
        'BE' => array(966),
        'BE-FR' => array(967),
        'DE' => array(964),
    ),
    CarRuleSet::GROUP_RECREATIONAL_ID => array(
        'NL' => array(3),
        'BE' => array(965),
        'BE-FR' => array(967),
        'DE' => array(963),
    ),
    CarRuleSet::GROUP_EXPORT_TOYOTA_ID => array(
        'NL' => array(7),
        'BE' => array(17),
        'BE-FR' => array(967),
        'DE' => array(67),
    ),
    CarRuleSet::GROUP_TRANSPORT_ID => array(
        'NL' => array(4),
        'BE' => array(14),
        'BE-FR' => array(967),
        'DE' => array(64),
    ),
    MotorRuleSet::GROUP_YOUNG_ID => array(
        'NL' => array(1),
        'BE' => array(11),
        'BE-FR' => array(11), // does not have motor young so it goes to same as be
        'DE' => array(19),
    ),
    MotorRuleSet::GROUP_OTHER_ID => array(
        'NL' => array(2),
        'BE' => array(12),
        'BE-FR' => array(12), // does not have motor other so it goes to same as be
        'DE' => array(20),
    ),
    MotorRuleSet::GROUP_DEMOLITION_ID => array(
        'NL' => array(3),
        'BE' => array(13),
        'BE-FR' => array(13), // does not have motor demolition so it goes to same as be
        'DE' => array(21),
    ),
    MotorRuleSet::GROUP_BUDGET_ID => array(
        'NL' => array(5),
        'BE' => array(15),
        'BE-FR' => array(15), // does not have motor budget so it goes to same as be
        'DE' => array(22),
    ),
    MotorRuleSet::GROUP_SCOOTER_OTHER_ID => array(
        'NL' => array(4),
        'BE' => array(14),
        'BE-FR' => array(14), // does not have motor scooter so it goes to same as be
        'DE' => array(23),
    ),
    MotorRuleSet::GROUP_SCOOTER_YOUNG_ID => array(
        'NL' => array(31),
        'BE' => array(14),
        'BE-FR' => array(14), // does not have motor scooter so it goes to same as be
        'DE' => array(23),
    ),
    MotorRuleSet::GROUP_SCOOTER_DEMOLITION_ID => array(
        'NL' => array(41),
        'BE' => array(14),
        'BE-FR' => array(14), // does not have motor scooter so it goes to same as be
        'DE' => array(23),
    )
);
