<?php

namespace DealerDirect\VehicleClassification;

use DealerDirect\VehicleClassification\Rules\Cars;
use DealerDirect\VehicleClassification\Rules\Motors;

/**
 * Class DefaultGroupRulesSetsFactory
 *
 * Factory to create default sets of Group Rules for DealerDirect
 *
 * @package DealerDirect\VehicleClassification
 */
abstract class DefaultGroupRulesSetsFactory
{

    /**
     * Get all rulesets for cars and motorcycles combined.
     *
     * @return array<\DealerDirect\VehicleClassification\Rules\GroupRulesInterface> Returns array of all group sets
     */
    public static function getAllGroupSets()
    {
        return array(
            new Cars\GroupRecreationalRules(),
            new Cars\GroupTransportRules(),
            new Cars\GroupToyotaExportRules(),
            new Cars\GroupPremiumExclusiveRules(),
            new Cars\GroupPremiumClassicRules(),
            new Cars\GroupExportRules(),
            new Cars\GroupYoungRules(),
            new Cars\GroupHighRules(),
            new Cars\GroupLowRules(),
            new Cars\GroupBottomRules(),
            new Cars\GroupDemolitionRules(),
            new Motors\GroupYoungRules(),
            new Motors\GroupOtherRules(),
            new Motors\GroupBudgetRules(),
            new Motors\GroupDemolitionRules(),
            new Motors\GroupScooterRules(),
        );
    }

    /**
     * Get a set of GroupRules for car vehicles
     *
     * @return array<\DealerDirect\VehicleClassification\Rules\GroupRulesInterface> Returns array of car nl group rules
     */
    public static function getDefaultCarGroupRulesSet()
    {
        return array(
            new Cars\GroupRecreationalRules(),
            new Cars\GroupTransportRules(),
            new Cars\GroupToyotaExportRules(),
            new Cars\GroupPremiumExclusiveRules(),
            new Cars\GroupPremiumClassicRules(),
            new Cars\GroupExportRules(),
            new Cars\GroupYoungRules(),
            new Cars\GroupHighRules(),
            new Cars\GroupLowRules(),
            new Cars\GroupBottomRules(),
            new Cars\GroupDemolitionRules(),
        );
    }

    /**
     * Get a set of GroupRules for car vehicles
     *
     * GroupBottomRules should not be included for DE and BE
     *
     * @return array<\DealerDirect\VehicleClassification\Rules\GroupRulesInterface> Returns array of not car nl group
     * rules
     */
    public static function getDefaultCarGroupRulesSetNotNL()
    {
        return array(
            new Cars\GroupRecreationalRules(),
            new Cars\GroupTransportRules(),
            new Cars\GroupToyotaExportRules(),
            new Cars\GroupPremiumExclusiveRules(),
            new Cars\GroupPremiumClassicRules(),
            new Cars\GroupExportRules(),
            new Cars\GroupYoungRules(),
            new Cars\GroupHighRules(),
            new Cars\GroupLowRules(),
            new Cars\GroupDemolitionRules(),
        );
    }

    /**
     * Get a set of GroupRules for motorcycle vehicles
     *
     * @return array<\DealerDirect\VehicleClassification\Rules\GroupRulesInterface> Returns array of motor group rules
     */
    public static function getDefaultMotoGroupRulesSet()
    {
        return array(
            new Motors\GroupYoungRules(),
            new Motors\GroupOtherRules(),
            new Motors\GroupBudgetRules(),
            new Motors\GroupDemolitionRules(),
            new Motors\GroupScooterRules(),
        );
    }

}
