<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;

class GroupLowRules implements GroupRulesInterface
{
    /**
     * @var Rule
     */
    private $groupRule;

    public function __construct()
    {
        $currentYear = (int)date('Y');

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                // Low  > 600, 2002 - 2004
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::lessThanOrEqualTo('yearOfManufacture', $currentYear - 13),
                    ConditionUtils::greaterThanOrEqualTo('yearOfManufacture', $currentYear - 15),
                    ConditionUtils::greaterThanOrEqualTo('askingPrice', 600),
                    ConditionUtils::lessThanOrEqualTo('askingPrice', 5000),
                    ConditionUtils::notEqualTo('numberOfDoors', 5)
                    // NOTE: If we should filter by airco we miss many classifications
                )),
                // Low  > 600, 2002 - 2004
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::lessThanOrEqualTo('yearOfManufacture', $currentYear - 16),
                    ConditionUtils::greaterThanOrEqualTo('yearOfManufacture', $currentYear - 27),
                    ConditionUtils::greaterThanOrEqualTo('askingPrice', 600),
                    ConditionUtils::lessThanOrEqualTo('askingPrice', 4000)
                )),
            ))
        );
    }

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_LOW_ID;
    }
}
