<?php

namespace DealerDirect\VehicleClassification\Rules;

use Ruler\Context;

/**
 * Interface GroupRules
 *
 * Every DealerDirect vehicle classification rule must implement this interface.
 */
interface GroupRulesInterface
{
    const GROUP_NO_ID = 0;

    // Cars group
    const GROUP_CARS_DEMOLITION_ID = 1;
    const GROUP_CARS_EXPORT_ID = 2;
    const GROUP_CARS_HIGH_ID = 3;
    const GROUP_CARS_YOUNG_ID = 4;
    const GROUP_CARS_LOW_ID = 5;
    const GROUP_CARS_BOTTOM_ID = 6;
    const GROUP_CARS_PREMIUM_ID = 7;
    const GROUP_CARS_PREMIUM_EXCLUSIVE_ID = 8;
    const GROUP_CARS_PREMIUM_CLASSIC_ID = 9;
    const GROUP_CARS_EXPORT_TOYOTA_ID = 11;
    const GROUP_CARS_RECREATIONAL_ID = 10;
    const GROUP_CARS_TRANSPORT_ID = 12;

    // Motors group
    const GROUP_MOTORS_YOUNG_ID = 40;
    const GROUP_MOTORS_OTHER_ID = 41;
    const GROUP_MOTORS_DEMOLITION_ID = 42;
    const GROUP_MOTORS_BUDGET_ID = 43;
    const GROUP_MOTORS_SCOOTER_ID = 44;

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId();

    /**
     * @param Context $context The Vehicle context
     * @return bool
     */
    public function evaluate(Context $context);
}
