<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupYoungRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupYoung
     */
    public function testGroupYoungCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupYoungRules = new GroupYoungRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupYoungRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupYoung
     */
    public function testGroupYoungWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupYoungRules = new GroupYoungRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupYoungRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupYoung()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 60000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 2015,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => '30000'
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupYoung()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 88000,
                'makeName' => 'VOLVO',
                'modelName' => 'AMAZON',
                'yearOfManufacture' => 1969,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => '0'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 140000,
                'makeName' => 'SKODA',
                'modelName' => 'SUPERB',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '8284',
                'askingPrice' => '17000'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 141954,
                'makeName' => 'PEUGEOT',
                'modelName' => '206',
                'yearOfManufacture' => 1999,
                'fuelType' => '1',
                'bpm' => '2434',
                'askingPrice' => '1000'
            ))
        );
    }
}
