<?php

require realpath(__DIR__ . '../../'). 'vendor/autoload.php';

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\VehicleClassification;
use DealerDirect\VehicleClassification\DefaultGroupRulesSetsFactory;

$vehicle = (new Vehicle())
                ->setId(1)
                ->setDamageFree(true)
                ->setDrivable(true)
                ->setLicensePlate('9XRX22')
                ->setMakeName('CITROEN')
                ->setModelName('SAXO')
                ->setYearOfManufacture(2011)
                ->setFuelType('benzine')
                ->setMileage(150000);

// Classify the vehicle:
$vehicleClassification = VehicleClassification::create(DefaultGroupRulesSetsFactory::getDefaultCarGroupRulesSet());
$classifiedGroupID = $vehicleClassification->classifyVehicle($vehicle);
var_dump($classifiedGroupID);
