<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Operator;
use Ruler\Rule;

class GroupPremiumClassicRules extends GroupPremiumRules implements GroupRulesInterface
{

    public function __construct()
    {
        $currentYear = (int)date('Y');

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                ConditionUtils::lessThanOrEqualTo('yearOfManufacture', $currentYear - 30)
            ))
        );
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_PREMIUM_CLASSIC_ID;
    }
}
