<?php

namespace DealerDirect\VehicleClassification\Rules;

use DealerDirect\VehicleClassification\Models\FuelUtils;
use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\Cars\GroupChecklistRules;
use Ruler\Context;

class GroupChecklistRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test Checklist group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupChecklist
     */
    public function testGroupChecklistCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupChecklistRules = new GroupChecklistRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupChecklistRules->evaluate($context));
    }

    /**
     * Test Checklist group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupChecklist
     */
    public function testGroupChecklistWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupChecklistRules = new GroupChecklistRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupChecklistRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupChecklist()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 204000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 0,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 200,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'makeName' => 'PEUGEOT',
                'modelName' => '206',
                'fuelType' => 'benzine',
                'mileage' => '15000',
                'yearOfManufacture' => '',
                'bpm' => '2729',
                'con_carrosserie' => '3',
                'damageFree' => '0',
                'driveable' => '1',
                'askingPrice' => 450,
                'actualValue' => 250,
                'carrosserie' => '1',
                'uitvoering' => '206 Gentry 1.4',
                'motorinhoud' => '1360'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => false,
                'makeName' => 'TOYOTA',
                'modelName' => 'Corolla',
                'fuelType' => FuelUtils::DIESEL,
                'mileage' => 204000,
                'bpm' => 409,
                'askingPrice' => 1000,
                'numberOfDoors' => 3
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupChecklist()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 155000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 2002,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 500,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'makeName' => 'PEUGEOT',
                'modelName' => '206',
                'fuelType' => 'benzine',
                'mileage' => '15000',
                'yearOfManufacture' => 2003,
                'bpm' => '2729',
                'con_carrosserie' => '3',
                'damageFree' => '0',
                'driveable' => '1',
                'askingPrice' => 450,
                'actualValue' => 250,
                'carrosserie' => '1',
                'uitvoering' => '206 Gentry 1.4',
                'motorinhoud' => '1360'
            )),
        );
    }
}
