<?php

namespace Dealerdirect\VehicleClassification\Rules\Motors;

use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\Models\VehicleTypeMotorBodyType as BodyType;
use Dealerdirect\VehicleClassification\Rules\Operators\CatchAll;
use Dealerdirect\VehicleClassification\Rules\RuleSet as BaseRuleSet;
use Dealerdirect\VehicleClassification\VehicleClassificationIds;
use Ruler\Operator\LogicalAnd;
use Ruler\Operator\LogicalOr;

class RuleSet extends BaseRuleSet
{
    public function __construct()
    {
        $rb = $this->getRuleBuilder();
        $currentYear = (int)date('Y');

        $this->addRule(
            $rb->create(
                new LogicalOr(
                    [
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Suzuki'),
                            $rb['modelName']->stringContainsInsensitive('VS 1400 INTRUDER')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Honda'),
                            $rb['modelName']->stringContainsInsensitive('XL 1000 V VARADERO')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Honda'),
                            $rb['modelName']->stringContainsInsensitive('STX 1300 PAN EUROPEAN')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Honda'),
                            $rb['modelName']->stringContainsInsensitive('XRV 750 AFRICA TWIN')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Honda'),
                            $rb['modelName']->stringContainsInsensitive('NTV700V DEAUVILLE')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Yamaha'),
                            $rb['modelName']->stringContainsInsensitive('XV 1600 WILDSTAR')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Yamaha'),
                            $rb['modelName']->stringContainsInsensitive('TDM 900')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Yamaha'),
                            $rb['modelName']->stringContainsInsensitive('FJR 1300')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Yamaha'),
                            $rb['modelName']->stringContainsInsensitive('FJR 1300 A')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Yamaha'),
                            $rb['modelName']->stringContainsInsensitive('FJR 1300 AE')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Yamaha'),
                            $rb['modelName']->stringContainsInsensitive('FJR 1300 AS')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Ducati'),
                            $rb['modelName']->stringContainsInsensitive('916')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Ducati'),
                            $rb['modelName']->stringContainsInsensitive('888')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Ducati'),
                            $rb['modelName']->stringContainsInsensitive('888 SP')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Ducati'),
                            $rb['modelName']->stringContainsInsensitive('851')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Ducati'),
                            $rb['modelName']->stringContainsInsensitive('900 SS')
                        ),
                        $rb->logicalAnd(
                            $rb['makeName']->stringContainsInsensitive('Ducati'),
                            $rb['modelName']->stringContainsInsensitive('900 SS SUPERLIGHT')
                        ),
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_BUDGET_ID
            )
        );

        // Type scooter of tot 50cc, Chinese merken zonder potentieel
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb->logicalOr(
                            $rb['makeName']->stringContainsInsensitive('ZNEN'),
                            $rb['makeName']->stringContainsInsensitive('Yiying'),
                            $rb['makeName']->stringContainsInsensitive('Xinix'),
                            $rb['makeName']->stringContainsInsensitive('Scooterking'),
                            $rb['makeName']->stringContainsInsensitive('Santini'),
                            $rb['makeName']->stringContainsInsensitive('Riya'),
                            $rb['makeName']->stringContainsInsensitive('Pronto'),
                            $rb['makeName']->stringContainsInsensitive('MTL'),
                            $rb['makeName']->stringContainsInsensitive('Luuko'),
                            $rb['makeName']->stringContainsInsensitive('Ilco'),
                            $rb['makeName']->stringContainsInsensitive('Lico'),
                            $rb['makeName']->stringContainsInsensitive('Huatian'),
                            $rb['makeName']->stringContainsInsensitive('Evader'),
                            $rb['makeName']->stringContainsInsensitive('Ebretti'),
                            $rb['makeName']->stringContainsInsensitive('Bajaj'),
                            $rb['makeName']->stringContainsInsensitive('Tym'),
                            $rb['makeName']->stringContainsInsensitive('Turbho'),
                            $rb['makeName']->stringContainsInsensitive('Luqi'),
                            $rb['makeName']->stringContainsInsensitive('Jonway'),
                            $rb['makeName']->stringContainsInsensitive('E-scooter'),
                            $rb['makeName']->stringContainsInsensitive('E-cooter'),
                            $rb['makeName']->stringContainsInsensitive('DTS'),
                            $rb['makeName']->stringContainsInsensitive('BTC'),
                            $rb['makeName']->stringContainsInsensitive('Berini'),
                            $rb['makeName']->stringContainsInsensitive('Senzo'),
                            $rb['makeName']->stringContainsInsensitive('GTS'),
                            $rb['makeName']->stringContainsInsensitive('La Souris'),
                            $rb['makeName']->stringContainsInsensitive('AGM'),
                            $rb['makeName']->stringContainsInsensitive('BOATIAN'),
                            $rb['makeName']->stringContainsInsensitive('FOSTI'),
                            $rb['makeName']->stringContainsInsensitive('KILLERBEE'),
                            $rb['makeName']->stringContainsInsensitive('NULL'),
                            $rb['makeName']->stringContainsInsensitive('TGB'),
                            $rb['makeName']->stringContainsInsensitive('KEEWAY'),
                            $rb['makeName']->stringContainsInsensitive('VOM'),
                            $rb['makeName']->stringContainsInsensitive('DTS'),
                            $rb['makeName']->stringContainsInsensitive('CPI'),
                            $rb['makeName']->stringContainsInsensitive('LINTEX'),
                            $rb['makeName']->stringContainsInsensitive('MOMO'),
                            $rb['makeName']->stringContainsInsensitive('ROVER BIKES'),
                            $rb['makeName']->stringContainsInsensitive('TIANYING'),
                            $rb['makeName']->stringContainsInsensitive('ZHONGNENG'),
                            $rb['makeName']->stringContainsInsensitive('YIYING'),
                            $rb['makeName']->stringContainsInsensitive('MOTORMANIA'),
                            $rb['makeName']->stringContainsInsensitive('EMCO'),
                            $rb['makeName']->stringContainsInsensitive('NIMOTO'),
                            $rb['makeName']->stringContainsInsensitive('MONASSO'),
                            $rb['makeName']->stringContainsInsensitive('ZEROBIKES'),
                            $rb['makeName']->stringContainsInsensitive('TAURIS'),
                            $rb['makeName']->stringContainsInsensitive('LIFAN'),
                            $rb['makeName']->stringContainsInsensitive('WLIE'),
                            $rb['makeName']->stringContainsInsensitive('LINGBEN'),
                            $rb['makeName']->stringContainsInsensitive('EVADER'),
                            $rb['makeName']->stringContainsInsensitive('RAZZO'),
                            $rb['makeName']->stringContainsInsensitive('GENERIC'),
                            $rb['makeName']->stringContainsInsensitive('BEELINE'),
                            $rb['makeName']->stringContainsInsensitive('LUQI'),
                            $rb['makeName']->stringContainsInsensitive('NECO'),
                            $rb['makeName']->stringContainsInsensitive('MODENA'),
                            $rb['makeName']->stringContainsInsensitive('NIPPONIA'),
                            $rb['makeName']->stringContainsInsensitive('GERRAY'),
                            $rb['makeName']->stringContainsInsensitive('VIRAGGIO'),
                            $rb['makeName']->stringContainsInsensitive('JIAJUE'),
                            $rb['makeName']->stringContainsInsensitive('YADEA'),
                            $rb['makeName']->stringContainsInsensitive('XINIX'),
                            $rb['makeName']->stringContainsInsensitive('HUATIAN'),
                            $rb['makeName']->stringContainsInsensitive('SCOMADI'),
                            $rb['makeName']->stringContainsInsensitive('YAMASAKI'),
                            $rb['makeName']->stringContainsInsensitive('HYOSUNG'),
                            $rb['makeName']->stringContainsInsensitive('WANGYE'),
                            $rb['makeName']->stringContainsInsensitive('QINGQI'),
                            $rb['makeName']->stringContainsInsensitive('BTM'),
                            $rb['makeName']->stringContainsInsensitive('BENDA'),
                            $rb['makeName']->stringContainsInsensitive('YIBEN'),
                            $rb['makeName']->stringContainsInsensitive('XINLING'),
                            $rb['makeName']->stringContainsInsensitive('IICO'),
                            $rb['makeName']->stringContainsInsensitive('ZHONGYU'),
                            $rb['makeName']->stringContainsInsensitive('NOVOX'),
                            $rb['makeName']->stringContainsInsensitive('LANBEI'),
                            $rb['makeName']->stringContainsInsensitive('LEIKE'),
                            $rb['makeName']->stringContainsInsensitive('YINGYANG'),
                            $rb['makeName']->stringContainsInsensitive('UNU'),
                            $rb['makeName']->stringContainsInsensitive('JDM'),
                            $rb['makeName']->stringContainsInsensitive('MODEN'),
                            $rb['makeName']->stringContainsInsensitive('TAOTAO'),
                            $rb['makeName']->stringContainsInsensitive('LUUKO'),
                            $rb['makeName']->stringContainsInsensitive('GERROE'),
                            $rb['makeName']->stringContainsInsensitive('XUFENG'),
                            $rb['makeName']->stringContainsInsensitive('SUNRA'),
                            $rb['makeName']->stringContainsInsensitive('EXPLORER'),
                            $rb['makeName']->stringContainsInsensitive('JMSTAR'),
                            $rb['makeName']->stringContainsInsensitive('MTL'),
                            $rb['makeName']->stringContainsInsensitive('EVT'),
                            $rb['makeName']->stringContainsInsensitive('JUNLUN'),
                            $rb['makeName']->stringContainsInsensitive('MBK'),
                            $rb['makeName']->stringContainsInsensitive('VENT MOTO'),
                            $rb['makeName']->stringContainsInsensitive('GRECAV SPA'),
                            $rb['makeName']->stringContainsInsensitive('DAYANG'),
                            $rb['makeName']->stringContainsInsensitive('FUJIAN'),
                            $rb['makeName']->stringContainsInsensitive('SUKIDA'),
                            $rb['makeName']->stringContainsInsensitive('HAINAN SUNDIRO'),
                            $rb['makeName']->stringContainsInsensitive('JAGAS'),
                            $rb['makeName']->stringContainsInsensitive('HUASHA'),
                            $rb['makeName']->stringContainsInsensitive('HANGLONG'),
                            $rb['makeName']->stringContainsInsensitive('KSR'),
                            $rb['makeName']->stringContainsInsensitive('TS'),
                            $rb['makeName']->stringContainsInsensitive('GOODYEAR'),
                            $rb['makeName']->stringContainsInsensitive('TOL'),
                            $rb['makeName']->stringContainsInsensitive('BEN LING'),
                            $rb['makeName']->stringContainsInsensitive('CHUANL'),
                            $rb['makeName']->stringContainsInsensitive('JNEN'),
                            $rb['makeName']->stringContainsInsensitive('CHUN LAN'),
                            $rb['makeName']->stringContainsInsensitive('SAMPO'),
                            $rb['makeName']->stringContainsInsensitive('NICOM'),
                            $rb['makeName']->stringContainsInsensitive('LONGJIA'),
                            $rb['makeName']->stringContainsInsensitive('SILENT FORCE'),
                            $rb['makeName']->stringContainsInsensitive('MEIJS'),
                            $rb['makeName']->stringContainsInsensitive('EMAX'),
                            $rb['makeName']->stringContainsInsensitive('MATTS'),
                            $rb['makeName']->stringContainsInsensitive('PMI'),
                            $rb['makeName']->stringContainsInsensitive('PGO'),
                            $rb['makeName']->stringContainsInsensitive('SMC'),
                            $rb['makeName']->stringContainsInsensitive('JIALING'),
                        )
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_LOW_POTENTIAL
            )
        );

        /**
         * Alle scooters mogen naar de bel groep Overig voor de time being.
         *
         * Als dit voor de lange termijn zo blijft kan de ruleset ook worden
         * opgeruimd.
         */

        // Type scooter of tot 50cc, Vespa als merk of in het model,
        // jonger dan 5 jaar en minder dan 20.000km
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb->logicalOr(
                            $rb['makeName']->stringContainsInsensitive('VESPA'),
                            $rb['modelName']->stringContainsInsensitive('VESPA')
                        ),
                        $rb['mileage']->lessThan(20000),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 5)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, Vespa als merk of in het model
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb->logicalOr(
                        $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                        $rb->logicalAnd(
                            $rb['engineCapacity']->greaterThanOrEqualTo(1),
                            $rb['engineCapacity']->lessThan(50)
                        )
                    ),
                    $rb->logicalOr(
                        $rb['makeName']->stringContainsInsensitive('VESPA'),
                        $rb['modelName']->stringContainsInsensitive('VESPA')
                    )
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, ouder dan 25 jaar
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb->logicalOr(
                        $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                        $rb->logicalAnd(
                            $rb['engineCapacity']->greaterThanOrEqualTo(1),
                            $rb['engineCapacity']->lessThan(50)
                        )
                    ),
                    $rb['yearOfManufacture']->lessThan($currentYear - 25)
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, meer dan 10.000, jonger dan 5 jaar
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb['mileage']->greaterThan(10000),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 5)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, jonger dan 5 jaar
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 5)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, meer dan 25.000, jonger dan 8 jaar
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb['mileage']->greaterThan(25000),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 8)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, jonger dan 8 jaar
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 8)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Type scooter of tot 50cc, minder dan 8.000km, jonger dan 11 jaar
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb->logicalOr(
                            $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                            $rb->logicalAnd(
                                $rb['engineCapacity']->greaterThanOrEqualTo(1),
                                $rb['engineCapacity']->lessThan(50)
                            )
                        ),
                        $rb['mileage']->lessThan(8000),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 11)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Overige scooters naar scooter schade en sloop
        $this->addRule(
            $rb->create(
                $rb->logicalOr(
                    $rb['vehicleType']->equalTo(Vehicle::TYPE_SCOOTER),
                    $rb->logicalAnd(
                        $rb['engineCapacity']->greaterThanOrEqualTo(1),
                        $rb['engineCapacity']->lessThan(50)
                    )
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Voertuig type Trike of Quad -> Jong & Fris:
        $this->addRule(
            $rb->create(
                $rb['bodyType']->equalTo(BodyType::TRIKE),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_YOUNG_ID
            )
        );

        // Voertuig type Klassier en merk BMW, Ducati, Benelli, Moto Guzzi, MZ of EML -> Overig
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    new LogicalOr(
                        [
                            $rb['modelName']->stringContainsInsensitive('BMW'),
                            $rb['modelName']->stringContainsInsensitive('DUCATI'),
                            $rb['modelName']->stringContainsInsensitive('BENELLI'),
                            $rb['modelName']->stringContainsInsensitive('MOTO GUZZI'),
                            $rb['modelName']->stringContainsInsensitive('MZ'),
                            $rb['modelName']->stringContainsInsensitive('EML'),
                        ]
                    ),
                    $rb['bodyType']->equalTo(BodyType::CLASSIC)
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Heeft het voertuig een zijspan -> Overige:
        $this->addRule(
            $rb->create(
                $rb['bodyType']->equalTo(BodyType::SIDE_CAR),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Is het voertuig van het merk Honda en bevat het model de tekst Goldwing of Gold wing
        // en is het voertuig jonger dan 15 jaar => Jong & Fris
        // Is het voertuig van het merk Harley Davison => Jong en Fris
        $this->addRule(
            $rb->create(
                $rb->logicalOr(
                    new LogicalAnd(
                        [
                            $rb['makeName']->equalTo('HONDA'),
                            $rb['modelName']->stringContainsInsensitive('GOLDWING'),
                            $rb['yearOfManufacture']->greaterThan($currentYear - 15)
                        ]
                    ),
                    $rb['makeName']->stringContainsInsensitive('HARLEY')
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_YOUNG_ID
            )
        );

        // Bevat het model de tekst Valkyrie, FJR, Wildstar of Midnight star en is het voertuig
        // ouder dan 9 jaar -> Overige
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    new LogicalOr(
                        [
                            $rb['modelName']->stringContainsInsensitive('VALKYRIE'),
                            $rb['modelName']->stringContainsInsensitive('FJR'),
                            $rb['modelName']->stringContainsInsensitive('WILDSTAR'),
                            $rb['modelName']->stringContainsInsensitive('MIDNIGHT STAR'),
                        ]
                    ),
                    $rb['yearOfManufacture']->lessThan($currentYear - 9)
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Bevat het model de tekst Goldwing of Gold wing en is het voertuig ouder dan 15 jaar -> Overig
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb->logicalOr(
                        $rb['modelName']->stringContainsInsensitive('GOLDWING'),
                        $rb['modelName']->stringContainsInsensitive('GOLD WING')
                    ),
                    $rb['yearOfManufacture']->lessThan($currentYear - 15)
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Is het voertuig van het merk BMW en heeft het minder dan 100.000km en is het een voertuig
        // tussen de 10 en 20 jaar oud -> Overige
        $this->addRule(
            $rb->create(
                new LogicalAnd(
                    [
                        $rb['makeName']->equalTo('BMW'),
                        $rb['mileage']->lessThan(100000),
                        $rb['yearOfManufacture']->greaterThan($currentYear - 20),
                        $rb['yearOfManufacture']->lessThan($currentYear - 10)
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Is het voertuig ouder dan 35 jaar -> Overig
        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->lessThan($currentYear - 35),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Is het voertuig jonger dan 9 jaar -> Jong & Fris
        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->greaterThan($currentYear - 9),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_YOUNG_ID
            )
        );

        // Is het voertuig jonger dan 15 jaar en heeft het minder dan 70.000km -> Overige
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb['yearOfManufacture']->greaterThan($currentYear - 15),
                    $rb['mileage']->lessThan(70000)
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Is het voertuig jonger dan 15 jaar -> Budget
        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->greaterThan($currentYear - 15),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_BUDGET_ID
            )
        );

        // Is het voertuig jonger dan 20 jaar en heeft het minder dan 40.000km -> Overige
        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb['yearOfManufacture']->greaterThan($currentYear - 20),
                    $rb['mileage']->lessThan(40000)
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_OTHER_ID
            )
        );

        // Is het voertuig jonger dan 20 jaar en heeft het minder dan 70.000km -> Budget
        // Is het voertuig jonger dan 25 jaar en heeft het minder dan 60.000km -> Budget
        $this->addRule(
            $rb->create(
                $rb->logicalOr(
                    $rb->logicalAnd(
                        $rb['yearOfManufacture']->greaterThan($currentYear - 20),
                        $rb['mileage']->lessThan(70000)
                    ),
                    $rb->logicalAnd(
                        $rb['yearOfManufacture']->greaterThan($currentYear - 25),
                        $rb['mileage']->lessThan(60000)
                    )
                ),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_BUDGET_ID
            )
        );
        // Catch all
        $this->addRule(
            $rb->create(
                new CatchAll(),
                fn () => $this->result = VehicleClassificationIds::CLASSIFICATION_DEMOLITION_ID
            )
        );
    }
}
