<?php

namespace Dealerdirect\VehicleClassification\Models;

/**
 * Class MotorOption
 *
 * Motorcycle options model.
 * Contains constants specifying all static Dealerdirect Motor option values.
 *
 * @package Dealerdirect\VehicleClassification\Models
 */
class MotorOptionInterface implements VehicleOptionInterface
{
    /**
     * ABS - Anti locking brake system
     */
    const ABS = 1;

    /**
     * Alarm system
     */
    const ALARM = 2;

    /**
     * Luggage system
     */
    const LUGGAGE_SYSTEM = 3;

    /**
     * Heated grips
     */
    const HEATED_GRIPS = 4;

    /**
     * Crash bars
     */
    const CRASH_BARS = 5;

    /**
     * Crash pads
     */
    const CRASH_PADS = 6;

    /**
     * Windscreen
     */
    const WINDSCREEN = 7;

    /**
     * Original exhaust system
     */
    const EXHAUST_SYSTEM_ORIGINAL = 8;

    /**
     * Aftermarket exhaust system
     */
    const EXHAUST_SYSTEM_AFTERMARKET = 9;

    /**
     * Original suspension
     */
    const SUSPENSION_ORIGINAL = 10;

    /**
     * Aftermarket suspension
     */
    const SUSPENSION_AFTERMARKET = 11;

    /**
     * Traction control
     */
    const TRACTION_CONTROL = 12;

    /**
     * Active suspension
     */
    const ACTIVE_SUSPENSION = 13;

    /**
     * Electronic Stability
     */
    const ELECTRONIC_STABILITY = 14;
}
