<?php

namespace Dealerdirect\VehicleClassification\Models;

/**
 * Class RecreationalOption
 *
 * Recreational vehicle options model.
 * Contains constants specifying all static Dealerdirect Recreational Vehicle option values.
 *
 * @package Dealerdirect\VehicleClassification\Models
 */
class RecreationalOptionInterface implements VehicleOptionInterface
{

    const BOILER = 101;

    const HITCH_LOCK = 102;

    const FLY_SCREEN = 103;

    const CANOPY = 104;

    const CARAVAN_MOVER = 105;

    const OVEN = 106;

    const STABILIZER = 107;

    const TELEVISION_ANTENNA = 108;

    const HEATER = 109;

    const WATER_TANK = 110;

    const ROOF_HOOD = 111;

    const SHOWER = 112;

    const FAN_HEATER = 113;

    const MICROWAVE = 114;

    const INVERTER = 115;

    const U_SHAPED_SEATING_GROUP = 116;

    const TOILET = 117;

    const FIXED_BED = 118;

    /**
     * Awning / tent ("Voortent")
     */
    const AWNING = 119;

    const DRAWBAR_COVER = 120;

    const BIKE_RACK = 121;

    /**
     * Refrigerator
     */
    const REFRIGERATOR = 122;
    const FRIDGE = 122;

    const CENTRAL_KITCHEN = 123;

    /**
     * Awning windows ("Openslaande ramen")
     */
    const AWNING_WINDOWS = 124;

    /**
     * Service hatch / "flap" ("Serviceluik")
     */
    const SERVICE_HATCH = 125;
    const FLAP = 125;

    const SIDE_SEATING_ARRANGEMENT = 126;

    /**
     * Wheels / Rims ("Velgen")
     */
    const RIMS = 127;

    /**
     * Awning light(s) ("Voortentlamp")
     */
    const AWNING_LIGHT = 128;
}
