# Vehicle Classification Library

(aka VCL)

## Introduction

The Vehicle Classification Library is a multiple rulesets implementation to
classify vehicles registered at Dealerdirect. These include: cars, motorcycles,
recreational and transport vehicles.
Implementation of rules is done using the `ruler/ruler` package

## Usage

### Vehicle Classification

Classifying a vehicle is done by passing a `Vehicle model` to the main
`VehicleClassification` processor.
It runs the supplied vehicle through a set of pre defined rules and will return
a "Classification Group ID", which is a suggestion in which
category to place the vehicle for Dealerdirect.

### Implementation

Can be implemented as follows:

1) Add the repository to your `composer.json`:

```json
"repositories": [
    {
        "type": "git",
        "url": "git@git.dealerdirect.io:php-packages/vehicle-classification.git"
    }
]
```

2) Include in your code:

```php
use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\VehicleClassification;
use Dealerdirect\VehicleClassification\Rules\Cars\RuleSet;

$vehicle = (new Vehicle())
                ->setId(1)
                ->setDamageFree(true)
                ->setDrivable(true)
                ->setLicensePlate('9XRX22')
                ->setMakeName('CITROEN')
                ->setModelName('SAXO')
                ->setYearOfManufacture(2011)
                ->setFuelType('benzine')
                ->setMileage(150000);

// Classify the vehicle
$vehicleClassification = new VehicleClassification(new RuleSet());
$classifiedGroupID = $vehicleClassification->classifyVehicle($vehicle);
```

### Example

There is an example `index.php` in the `scripts/examples` directory.
You can run this as follows:

```sh
php -S localhost:8888 -l scripts/examples/index.php
```

## Testing

Testing is done using PHPUnit.
You can execute this running in the root of the repository directory:

```sh
phpunit
```
