<?php

namespace Dealerdirect\VehicleClassification\Utils;

/**
 * Class Arrays
 *
 * Array utility class
 *
 * @package Dealerdirect\VehicleClassification\Utils
 */
class ArrayUtils
{
    /**
     * @param array $array The array
     * @param $key The key name
     * @param string|mixed $default
     *
     * @return mixed The array value
     */
    public static function getValue(array $array, $key, $default = '')
    {
        if (array_key_exists($key, $array)) {
            return $array[$key];
        }
        return $default;
    }

    /**
     * Get array value by key as integer type
     *
     * @param array $array
     * @param $key
     * @param int $default
     *
     * @return int
     */
    public static function getInt(array $array, $key, $default = 0)
    {
        if (array_key_exists($key, $array)) {
            return intval($array[$key]);
        }
        return $default;
    }

    /**
     * Get array value by key as boolean type
     *
     * @param array $array
     * @param $key
     * @param bool $default
     *
     * @return bool
     */
    public static function getBoolean(array $array, $key, $default = false)
    {
        if (array_key_exists($key, $array)) {
            return boolval($array[$key]);
        }
        return $default;
    }

    /**
     * Get array value by key as array
     *
     * @param array $array
     * @param $key
     * @param array $default Default array, default empty
     *
     * @return array
     */
    public static function getArray(array $array, $key, array $default = [])
    {
        if (array_key_exists($key, $array)) {
            if (is_array($array[$key])) {
                return $array[$key];
            } else {
                // wrap value in new array
                return array($array[$key]);
            }
        }
        return $default;
    }
}
