<?php

namespace DealerDirect\VehicleClassification\Rules\Operators;

use Ruler\Context;
use Ruler\Rule;
use Ruler\Value;
use Ruler\Variable;

/**
 * Condition util class Unit tests
 *
 * @package DealerDirect\VehicleClassification\Utils
 */
class CompanyLicensePlateEvaluatorTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Given license plate numbers should all pass
     *
     * @param string $licensePlate A Dutch Company vehicle "grey" license plate number
     *
     * @dataProvider provideCompanyVehicleLicensePlates
     */
    public function testGivenCompanyLicensePlateValuesShouldPass($licensePlate)
    {
        $rule = new Rule(
            new CompanyLicensePlateEvaluator(
                new Variable('licensePlate')
            )
        );

        $context = new Context(
            array(
                'licensePlate' => $licensePlate,
            )
        );

        $evaluationResult = $rule->evaluate($context);

        $this->assertTrue($evaluationResult);
    }

    /**
     * Given license plate numbers should all fail
     *
     * @param string $licensePlate A Dutch license plate number, which is NOT a "grey" company license plate
     *
     * @dataProvider provideNotCompanyVehicleLicensePlates
     */
    public function testGivenCompanyLicensePlateValuesShouldFail($licensePlate)
    {
        $rule = new Rule(
            new CompanyLicensePlateEvaluator(
                new Variable('licensePlate')
            )
        );

        $context = new Context(
            array(
                'licensePlate' => $licensePlate,
            )
        );

        $evaluationResult = $rule->evaluate($context);

        $this->assertFalse($evaluationResult);
    }

    public function provideCompanyVehicleLicensePlates()
    {
        return [
            ['1-BAT-23'],
            ['2-VAT-56'],
            ['BV-321-5'],
            ['V-721-XY'],
        ];
    }

    public function provideNotCompanyVehicleLicensePlates()
    {
        return [
            ['1-ABC-23'],
            ['2-TUV-56'],
            ['XY-321-Z'],
            ['A-721-XY'],
        ];
    }
}
