<?php

namespace Dealerdirect\VehicleClassification;

use Dealerdirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\Rules\RuleSet;
use Dealerdirect\VehicleClassification\CallGroupIds;
use Ruler\Context;

/**
 * Class VehicleClassification
 *
 * Main Vehicle Classification processor.
 *
 * @package Dealerdirect\VehicleClassification
 */
class VehicleClassification
{
    /**
     * @var RuleSet
     */
    private $ruleSet;

    /**
     * @var VehicleModelMapper
     */
    private $vehicleMapper;

    /**
     * VehicleClassification constructor.
     */
    public function __construct(RuleSet $ruleSet)
    {
        $this->vehicleMapper = new VehicleModelMapper();
        $this->ruleSet = $ruleSet;
    }

    /**
     * Classifies a vehicle to a given set of group rules.
     * It will return the Classification Group ID of the first matched group in the
     * Vehicle Classification GroupRules set.
     *
     * @param Vehicle $vehicle
     *
     * @return CallGroupIds Group ID in which vehicle will be classified
     */
    public function classifyVehicle(Vehicle $vehicle): CallGroupIds
    {
        $this->ruleSet->executeRules(
            new Context($this->vehicleMapper->toArray($vehicle))
        );

        return $this->ruleSet->getResult() ?? CallGroupIds::GROUP_NO_ID;
    }
}
