<?php

namespace DealerDirect\VehicleClassification\Models;

/**
 * Class VehicleOption
 *
 * Model for a vehicle option
 *
 * @package DealerDirect\VehicleClassification\Models
 */
class VehicleCondition
{

    // Condition not specified/unknown
    const UNKNOWN = 0;
    const NOT_SPECIFIED = 0;

    /**
     * Vehicle condition, "as good as *NEW*"
     */
    const AS_NEW = 1;
    const AS_NEW_CONDITION = 1;

    /**
     * Vehicle in *good* condition ("goed")
     */
    const GOOD = 2;
    const GOOD_CONDITION = 2;

    /**
     * Vehicle in *average* condition ("redelijk")
     */
    const AVERAGE = 3;
    const AVERAGE_CONDITION = 3;

    /**
     * Vehicle in *poor* condition ("matig")
     */
    const POOR = 4;
    const POOR_CONDITION = 4;

    /**
     * Vehicle in *bad* condition ("slecht")
     */
    const BAD = 5;
    const BAD_CONDITION = 5;
}
