<?php

namespace DealerDirect\VehicleClassification\Rules;

use Ruler\Context;
use Ruler\Rule;

/**
 * Class GroupRule
 * Wraps a `Ruler rule` with a target group id
 *
 * @package DealerDirect\VehicleClassification\Rules
 */
class GroupRule
{
    /**
     * @var Rule
     */
    protected $rule;

    /**
     * @var int
     */
    protected $targetGroupId;

    /**
     * GroupRule constructor.
     * @param Rule $rule
     * @param $targetGroupId
     */
    public function __construct(Rule $rule, $targetGroupId)
    {
        $this->rule = $rule;
        $this->targetGroupId = $targetGroupId;
    }

    /**
     * Evaluate the Rule with the given Context.
     *
     * @param Context $context Context with which to evaluate this Rule
     *
     * @return boolean
     */
    public function evaluate(Context $context)
    {
        return $this->rule->evaluate($context);
    }

    /**
     * @return Rule
     */
    public function getRule()
    {
        return $this->rule;
    }

    /**
     * @return int
     */
    public function getTargetGroupId()
    {
        return $this->targetGroupId;
    }
}
