<?php
namespace DealerDirect\VehicleClassification;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Rules\VehicleRuleSet;
use Ruler\Context;

/**
 * Class VehicleClassifier
 *
 * Classifies vehicles based on a given RuleSet
 *
 * @package DealerDirect\VehicleClassification
 */
class VehicleClassifier
{
    protected $ruleSet;


    public function __construct(VehicleRuleSet $ruleSet)
    {
        $this->ruleSet = $ruleSet;
    }

    /**
     * Evaluates given Vehicle against the RuleSet the VehicleClassifier is instantiated with,
     * and returns the Call Group ID as a result
     *
     * @param Vehicle $vehicle
     *
     * @return int Classified Group ID for given vehicle. Returns -1 in case no call group was found for the ruleset
     */
    public function getClassifiedGroupId(Vehicle $vehicle)
    {
        $mapper = new VehicleModelMapper();
        $vehicleData = $mapper->toArray($vehicle);
        $context = new Context($vehicleData);

        return $this->ruleSet->evaluate($context);
    }
}
