<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Models\FuelUtils;
use Ruler\Context;

class GroupLowWithKMRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupLowWithKM
     */
    public function testGroupLowWithKMCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupLowWithKMRules = new GroupLowWithKMRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupLowWithKMRules->evaluate($context));
    }

    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupLowWithKM
     */
    public function testGroupLowWithKMWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupLowWithKMRules = new GroupLowWithKMRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupLowWithKMRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupLowWithKM()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 110000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 1999,
                'fuelType' => '1',
                'bpm' => '10156',
                'numberOfDoors' => 3,
                'askingPrice' => 1650
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 90000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '10156',
                'numberOfDoors' => 4,
                'askingPrice' => 1650
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupLowWithKM()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 316000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '10156',
                'numberOfDoors' => 5,
                'askingPrice' => '1650'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 158000,
                'makeName' => 'SUZUKI',
                'modelName' => 'ALTO',
                'yearOfManufacture' => 2009,
                'fuelType' => '1',
                'bpm' => '1361',
                'askingPrice' => '750'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 200000,
                'makeName' => 'SEAT',
                'modelName' => 'IBIZA',
                'yearOfManufacture' => 2002,
                'fuelType' => '1',
                'bpm' => '3024',
                'askingPrice' => '0'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 280000,
                'makeName' => 'FORD',
                'modelName' => 'TRANSIT',
                'yearOfManufacture' => 2008,
                'fuelType' => '2',
                'bpm' => '10196',
                'askingPrice' => '0'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 200000,
                'makeName' => 'VOLKSWAGEN',
                'modelName' => 'POLO',
                'yearOfManufacture' => 2010,
                'fuelType' => '2',
                'bpm' => '0',
                'askingPrice' => '5500'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 200000,
                'makeName' => 'MERCEDES-BENZ',
                'modelName' => 'ML-KLASSE',
                'yearOfManufacture' => 2007,
                'fuelType' => '2',
                'bpm' => '0',
                'askingPrice' => '10000'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 42000,
                'makeName' => 'OPEL',
                'modelName' => 'CORSA',
                'yearOfManufacture' => 2009,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => '5500'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 200000,
                'makeName' => 'MERCEDES-BENZ',
                'modelName' => 'ML-KLASSE',
                'yearOfManufacture' => 2007,
                'fuelType' => '2',
                'bpm' => '0',
                'askingPrice' => '10000'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 83000,
                'makeName' => 'MERCEDES-BENZ',
                'modelName' => 'A-KLASSE',
                'yearOfManufacture' => 2013,
                'fuelType' => '1',
                'bpm' => '5000',
                'askingPrice' => '19500'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 32000,
                'makeName' => 'TOYOTA',
                'modelName' => 'PRIUS',
                'yearOfManufacture' => 2008,
                'fuelType' => FuelUtils::HYBRID_GASOLINE,
                'bpm' => '0',
                'askingPrice' => '6000'
            )),
        );
    }
}
