<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\FuelUtils;
use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupPremiumExclusiveRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test PremiumExclusive group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupPremiumExclusive
     */
    public function testGroupPremiumExclusiveCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupPremiumExclusiveRules = new GroupPremiumExclusiveRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupPremiumExclusiveRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupPremiumExclusive
     */
    public function testGroupPremiumExclusiveWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupPremiumExclusiveRules = new GroupPremiumExclusiveRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupPremiumExclusiveRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupPremiumExclusive()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 204000,
                'makeName' => 'FERRARI',
                'modelName' => '488 GTB',
                'yearOfManufacture' => 2009,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 200000,
                'listPrice' => 249150,
                'numberOfDoors' => 2
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 73000,
                'makeName' => 'PORSCHE',
                'modelName' => 'CARRERA',
                'yearOfManufacture' => 2004,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 8000,
                'askingPrice' => 65000,
                'listPrice' => 89000,
                'numberOfDoors' => 2
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 56500,
                'makeName' => 'PORSCHE',
                'modelName' => '911 TURBO',
                'yearOfManufacture' => 2002,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 80000,
                'listPrice' => 120000,
                'numberOfDoors' => 2
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupPremiumExclusive()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 155000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 2015,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 30000,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 190000,
                'makeName' => 'SKODA',
                'modelName' => 'SUPERB',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '8284',
                'askingPrice' => 17000,
                'numberOfDoors' => 3
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 86000,
                'yearOfManufacture' => 1999,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 8000,
                'askingPrice' => 65000,
                'listPrice' => 89000,
                'numberOfDoors' => 2
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 44000,
                'yearOfManufacture' => 1986,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 0,
                'askingPrice' => 72000,
                'listPrice' => 100000,
                'numberOfDoors' => 2
            )),
        );
    }
}
