<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;

class GroupLowHangingRules implements GroupRulesInterface
{
    private $groupRule;

    public function __construct()
    {
        $currentYear = (int) date('Y');

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                new Operator\LogicalAnd(array(
                    ConditionUtils::lessThanOrEqualTo('yearOfManufacture', $currentYear - 13),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::greaterThan('valuationPrice', 0),
                    ConditionUtils::lessThanOrEqualTo('valuationPrice', 350),
                ))
            ))
        );
    }

    /**
    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_NO_ID;
    }
}
