<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\AbstractGroupRules;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Rule;

class GroupScooterRules extends AbstractGroupRules
{
    public function __construct()
    {
        $this->groupRule = new Rule(
            self::_OR_([
                ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_SCOOTER),
                self::_AND_([
                    // Engine capacity less than 50 cc
                    ConditionUtils::greaterThanOrEqualTo('engineCapacity', 1),
                    ConditionUtils::lessThan('engineCapacity', 50),
                ])
            ])
        );
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_MOTORS_SCOOTER_ID;
    }
}
