<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupLowRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupLow
     */
    public function testGroupLowCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupLowRules = new GroupLowRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupLowRules->evaluate($context));
    }

    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupLow
     */
    public function testGroupLowWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupLowRules = new GroupLowRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupLowRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupLow()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 110000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => $currentYear-16,
                'fuelType' => '1',
                'bpm' => '10156',
                'numberOfDoors' => 3,
                'askingPrice' => 1650
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 90000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => $currentYear-15,
                'fuelType' => '1',
                'bpm' => '10156',
                'numberOfDoors' => 4,
                'askingPrice' => 1650
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupLow()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 316000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => $currentYear-11,
                'fuelType' => '1',
                'bpm' => '10156',
                'numberOfDoors' => 5,
                'askingPrice' => '1650'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 158000,
                'makeName' => 'SUZUKI',
                'modelName' => 'ALTO',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '1361',
                'askingPrice' => '750'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 113000,
                'makeName' => 'SEAT',
                'modelName' => 'IBIZA',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '3024',
                'askingPrice' => '0'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 280000,
                'makeName' => 'FORD',
                'modelName' => 'TRANSIT',
                'yearOfManufacture' => $currentYear-4,
                'fuelType' => '2',
                'bpm' => '10196',
                'askingPrice' => '0'
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 197000,
                'makeName' => 'VOLKSWAGEN',
                'modelName' => 'POLO',
                'yearOfManufacture' => $currentYear-3,
                'fuelType' => '2',
                'bpm' => '0',
                'askingPrice' => '5500'
            ))
        );
    }
}
