<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupScooterRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test scooter group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupScooter
     */
    public function testGroupScooterCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupScooterRules = new GroupScooterRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupScooterRules->evaluate($context));
    }

    /**
     * Test scooter group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupScooter
     */
    public function testGroupScooterWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupScooterRules = new GroupScooterRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupScooterRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupScooter()
    {
        return array(
            array(array(
                'engineCapacity' => 45,
                'damageFree' => '2',
                'mileage' => 3600,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => '2',
                'mileage' => 3600,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => '1',
                'mileage' => 14000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2008,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => '1',
                'mileage' => 15000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => 2004,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => true,
                'mileage' => 90000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => true,
                'mileage' => 85000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => true,
                'mileage' => 85000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => 2007,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => '1',
                'mileage' => 45000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2013,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_SCOOTER,
                'damageFree' => '1',
                'mileage' => 45000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2007,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 13500
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupScooter()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 25850,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 90000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => 2000,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 120000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 101000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => 2007,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 60000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2013,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 13500
            )),
        );
    }

}
