<?php
namespace DealerDirect\VehicleClassification\Rules;

use Ruler\Context;
use Ruler\Operator;

abstract class AbstractGroupRules implements GroupRulesInterface
{
    /**
     * @var Rule
     */
    protected $groupRule;

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * @param array $expression
     * @return Operator\LogicalAnd
     */
    public static function _AND_(array $expression)
    {
        return new Operator\LogicalAnd($expression);
    }

    public static function _OR_(array $expression)
    {
        return new Operator\LogicalOr($expression);
    }
}
