<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Models\VehicleTypeCarBodyType;
use DealerDirect\VehicleClassification\Rules\AbstractGroupRules;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Rule;

class GroupRecreationalRules extends AbstractGroupRules
{
    public function __construct()
    {
        $this->groupRule = new Rule(
            self::_OR_([
                ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_RECREATIONAL),
                ConditionUtils::isOneOf('bodyType', [
                    VehicleTypeCarBodyType::CAMPER,
                    VehicleTypeCarBodyType::CARAVAN,
                    VehicleTypeCarBodyType::FOLDING_CARAVAN
                ])
            ])            
        );
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_RECREATIONAL_ID;
    }
}
