<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Models\VehicleTypeCarBodyType;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Rules\Operators\CompanyLicensePlateEvaluator;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use DealerDirect\VehicleClassification\Rules\AbstractGroupRules;
use Ruler\Rule;
use Ruler\Variable;

class GroupTransportRules extends AbstractGroupRules
{
    public function __construct()
    {
        $this->groupRule = new Rule(
            self::_OR_([
                ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_TRANSPORT),
                ConditionUtils::equalTo('bodyType', VehicleTypeCarBodyType::VAN_SINGLE_CABIN),
                ConditionUtils::equalTo('bodyType', VehicleTypeCarBodyType::VAN_DOUBLE_CABIN),
                // If the license plate starts with 'V' or 'B'
                // This is only for NL!:
                new CompanyLicensePlateEvaluator(
                    new Variable('licensePlate')
                )
            ])
        );
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_TRANSPORT_ID;
    }
}
