<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupHighRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupHigh
     */
    public function testGroupHighCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupHighRules = new GroupHighRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupHighRules->evaluate($context));
    }

    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupHigh
     */
    public function testGroupHighWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupHighRules = new GroupHighRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupHighRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupHigh()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 120000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => $currentYear-9,
                'fuelType' => '1',
                'bpm' => '10156',
                'askingPrice' => 1650
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 90000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => $currentYear-10,
                'fuelType' => '1',
                'bpm' => '10156',
                'askingPrice' => 1650
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupHigh()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 316000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => $currentYear-2,
                'fuelType' => '1',
                'bpm' => '10156',
                'askingPrice' => 1650
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 158000,
                'makeName' => 'SUZUKI',
                'modelName' => 'ALTO',
                'yearOfManufacture' => $currentYear-7,
                'fuelType' => '1',
                'bpm' => '1361',
                'askingPrice' => 750
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 113000,
                'makeName' => 'SEAT',
                'modelName' => 'IBIZA',
                'yearOfManufacture' => $currentYear-8,
                'fuelType' => '1',
                'bpm' => '3024',
                'askingPrice' => 0
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 280000,
                'makeName' => 'FORD',
                'modelName' => 'TRANSIT',
                'yearOfManufacture' => $currentYear-7,
                'fuelType' => '2',
                'bpm' => '10196',
                'askingPrice' => 0
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 210000,
                'makeName' => 'VOLKSWAGEN',
                'modelName' => 'POLO',
                'yearOfManufacture' => $currentYear-7,
                'fuelType' => '2',
                'bpm' => '0',
                'askingPrice' => 5500
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 42000,
                'makeName' => 'OPEL',
                'modelName' => 'CORSA',
                'yearOfManufacture' => $currentYear-8,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5500
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 83000,
                'makeName' => 'MERCEDES-BENZ',
                'modelName' => 'A-KLASSE',
                'yearOfManufacture' => $currentYear-4,
                'fuelType' => '1',
                'bpm' => '5000',
                'askingPrice' => 19500
            ))
        );
    }
}
