<?php

namespace Dealerdirect\VehicleClassification\Rules\Cars;

use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\Models\VehicleTypeCarBodyType;
use Dealerdirect\VehicleClassification\Rules\Operators\CatchAll;
use Dealerdirect\VehicleClassification\Rules\RuleSet as BaseRuleSet;
use Dealerdirect\VehicleClassification\VehicleClassificationIds;
use Ruler\Operator\LogicalOr;

class RuleSet extends BaseRuleSet
{
    public function __construct()
    {
        $rb = $this->getRuleBuilder();
        $currentYear = (int) date('Y');

        $this->addRule(
            $rb->create(
                new LogicalOr(
                    [
                        $rb['vehicleType']->equalTo(Vehicle::TYPE_RECREATIONAL),
                        $rb['bodyType']->equalTo(VehicleTypeCarBodyType::CAMPER),
                        $rb['bodyType']->equalTo(VehicleTypeCarBodyType::CARAVAN),
                        $rb['bodyType']->equalTo(VehicleTypeCarBodyType::FOLDING_CARAVAN),
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::GROUP_RECREATIONAL_ID
            )
        );

        $this->addRule(
            $rb->create(
                new LogicalOr(
                    [
                        $rb['vehicleType']->equalTo(Vehicle::TYPE_TRANSPORT),
                        $rb['bodyType']->equalTo(VehicleTypeCarBodyType::VAN_SINGLE_CABIN),
                        $rb['bodyType']->equalTo(VehicleTypeCarBodyType::VAN_DOUBLE_CABIN),
                        $rb['licensePlate']->companyLicensePlate(),
                    ]
                ),
                fn () => $this->result = VehicleClassificationIds::GROUP_TRANSPORT_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->isEmpty(),
                fn () => $this->result = VehicleClassificationIds::GROUP_NO_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->lessThanOrEqualTo($currentYear - 30),
                fn () => $this->result = VehicleClassificationIds::GROUP_PREMIUM_CLASSIC_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->lessThanOrEqualTo($currentYear - 20),
                fn () => $this->result = VehicleClassificationIds::GROUP_DEMOLITION_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb['yearOfManufacture']->lessThanOrEqualTo($currentYear - 13),
                    $rb['mileage']->lessThan(199999)
                ),
                fn () => $this->result = VehicleClassificationIds::GROUP_LOW_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb->logicalAnd(
                    $rb['yearOfManufacture']->greaterThanOrEqualTo($currentYear - 15),
                    $rb['mileage']->greaterThan(199999)
                ),
                fn () => $this->result = VehicleClassificationIds::GROUP_EXPORT_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->lessThanOrEqualTo($currentYear - 13),
                fn () => $this->result = VehicleClassificationIds::GROUP_LOW_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb['yearOfManufacture']->lessThanOrEqualTo($currentYear - 9),
                fn () => $this->result = VehicleClassificationIds::GROUP_HIGH_ID
            )
        );

        $this->addRule(
            $rb->create(
                $rb['mileage']->greaterThanOrEqualTo(120000),
                fn () => $this->result = VehicleClassificationIds::GROUP_HIGH_ID
            )
        );

        // Catch all
        $this->addRule(
            $rb->create(
                new CatchAll(),
                fn () => $this->result = VehicleClassificationIds::GROUP_YOUNG_ID
            )
        );
    }
}
