<?php

namespace Dealerdirect\VehicleClassification;

use DealerDirect\Generic\Category\Site;
use Exception;

enum VehicleClassificationIds: int
{
    case GROUP_NO_ID = 0;
    case GROUP_DEMOLITION_ID = 1;
    case GROUP_EXPORT_ID = 2;
    case GROUP_HIGH_ID = 3;
    case GROUP_YOUNG_ID = 4;
    case GROUP_LOW_ID = 5;
    case GROUP_PREMIUM_EXCLUSIVE_ID = 6;
    case GROUP_PREMIUM_CLASSIC_ID = 7;
    case GROUP_RECREATIONAL_ID = 8;
    // case GROUP_EXPORT_TOYOTA_ID = 9;
    case GROUP_TRANSPORT_ID = 10;
    case GROUP_OTHER_ID = 11;
    case GROUP_BUDGET_ID = 12;
    case GROUP_SCOOTER_OTHER_ID = 13;
    case GROUP_SCOOTER_YOUNG_ID = 14;
    case GROUP_SCOOTER_DEMOLITION_ID = 15;

    public function toCallgroupId(int $reference, bool $returnAll = false): array|int
    {
        Site::assertExists($reference);

        //phpcs:ignore PHPCompatibility.Variables.ForbiddenThisUseContexts.OutsideObjectContext
        $mapping = $this->mapping();
        if (!array_key_exists($reference, $mapping)) {
            throw new Exception('Error, could not find reference');
        }

        $callgroupIds = $mapping[$reference];

        return $returnAll
            ? $callgroupIds
            : (int) $callgroupIds[array_rand($callgroupIds)];
    }

    private function mapping()
    {
        //phpcs:ignore PHPCompatibility.Variables.ForbiddenThisUseContexts.OutsideObjectContext
        return match ($this) {
            self::GROUP_NO_ID => [
                Site::REF_CAR_NL => [950],
                Site::REF_CAR_BE_NL => [951],
                Site::REF_CAR_BE_FR => [952],
                Site::REF_CAR_DE => [953],
                Site::REF_CAR_MARKTPLAATS_NL => [968],
                Site::REF_SCOOTER_NL => [2],
                Site::REF_MOTO_NL => [2],
                Site::REF_MOTO_BE => [12],
                Site::REF_MOTO_DE => [20],
            ],
            self::GROUP_DEMOLITION_ID => [
                Site::REF_CAR_NL => [2],
                Site::REF_CAR_BE_NL => [12],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [62],
                Site::REF_CAR_MARKTPLAATS_NL => [80],
                Site::REF_SCOOTER_NL => [3],
                Site::REF_MOTO_NL => [3],
                Site::REF_MOTO_BE => [13],
                Site::REF_MOTO_DE => [21],
                Site::REF_BICYCLE_NL => [61],
            ],
            self::GROUP_EXPORT_ID => [
                Site::REF_CAR_NL => [7],
                Site::REF_CAR_BE_NL => [17],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [67],
                Site::REF_CAR_MARKTPLAATS_NL => [84],
            ],
            self::GROUP_HIGH_ID => [
                Site::REF_CAR_NL => [8, 21],
                Site::REF_CAR_BE_NL => [18],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [65],
                Site::REF_CAR_MARKTPLAATS_NL => [85],
            ],
            self::GROUP_YOUNG_ID => [
                Site::REF_CAR_NL => [1],
                Site::REF_CAR_BE_NL => [11],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [61],
                Site::REF_CAR_MARKTPLAATS_NL => [79],
                Site::REF_SCOOTER_NL => [1],
                Site::REF_MOTO_NL => [1],
                Site::REF_MOTO_BE => [11],
                Site::REF_MOTO_DE => [19],
                Site::REF_BICYCLE_NL => [51],
            ],
            self::GROUP_LOW_ID => [
                Site::REF_CAR_NL => [5, 20],
                Site::REF_CAR_BE_NL => [15],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [66],
                Site::REF_CAR_MARKTPLAATS_NL => [83],
            ],
            self::GROUP_PREMIUM_CLASSIC_ID => [
                Site::REF_CAR_NL => [69],
                Site::REF_CAR_BE_NL => [966],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [964],
                Site::REF_CAR_MARKTPLAATS_NL => [86],
            ],
            self::GROUP_RECREATIONAL_ID => [
                Site::REF_CAR_NL => [3],
                Site::REF_CAR_BE_NL => [965],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [963],
                Site::REF_CAR_MARKTPLAATS_NL => [81],
            ],
            self::GROUP_TRANSPORT_ID => [
                Site::REF_CAR_NL => [4],
                Site::REF_CAR_BE_NL => [14],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [64],
                Site::REF_CAR_MARKTPLAATS_NL => [82],
            ],
            self::GROUP_OTHER_ID => [
                Site::REF_SCOOTER_NL => [2],
                Site::REF_MOTO_NL => [2],
                Site::REF_MOTO_BE => [12],
                Site::REF_MOTO_DE => [20],
            ],
            self::GROUP_BUDGET_ID => [
                Site::REF_SCOOTER_NL => [5],
                Site::REF_MOTO_NL => [5],
                Site::REF_MOTO_BE => [15],
                Site::REF_MOTO_DE => [22],
            ],
            self::GROUP_SCOOTER_OTHER_ID => [
                Site::REF_SCOOTER_NL => [4],
                Site::REF_MOTO_NL => [4],
                Site::REF_MOTO_BE => [14],
                Site::REF_MOTO_DE => [23],
            ],
            self::GROUP_SCOOTER_YOUNG_ID => [
                Site::REF_SCOOTER_NL => [31],
                Site::REF_MOTO_NL => [31],
                Site::REF_MOTO_BE => [14],
                Site::REF_MOTO_DE => [23],
            ],
            self::GROUP_SCOOTER_DEMOLITION_ID => [
                Site::REF_SCOOTER_NL => [41],
                Site::REF_MOTO_NL => [41],
                Site::REF_MOTO_BE => [14],
                Site::REF_MOTO_DE => [23],
            ],
        };
    }
}
