<?php

namespace Dealerdirect\VehicleClassification\Rules\Bicycle;

use Dealerdirect\VehicleClassification\Rules\Operators\CatchAll;
use Dealerdirect\VehicleClassification\Rules\RuleSet as BaseRuleSet;
use Dealerdirect\VehicleClassification\VehicleClassificationIds;
use Ruler\Operator\LogicalAnd;

class RuleSet extends BaseRuleSet
{
    public function __construct()
    {
        $rb = $this->getRuleBuilder();
        $currentYear = (int)date('Y');

        // TODO: Change these rules as rules are not yet spicified.
        $this->addRule(
            $rb->create(
                new LogicalAnd([
                    $rb['yearOfManufacture']->greaterThan($currentYear - 6)
                ]),
                fn () => $this->result = VehicleClassificationIds::GROUP_YOUNG_ID
            )
        );

        // Catch all
        $this->addRule(
            $rb->create(
                new CatchAll(),
                fn () => $this->result = VehicleClassificationIds::GROUP_DEMOLITION_ID
            )
        );
    }
}
