<?php

namespace Dealerdirect\VehicleClassification\Tests\Models;

use Dealerdirect\VehicleClassification\Models\CarOption;
use Dealerdirect\VehicleClassification\Models\FuelUtils;
use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\Models\VehicleCondition;
use PHPUnit\Framework\TestCase;

class VehicleOptionsTest extends TestCase
{
    private $carOptions = array(
        CarOption::AIR_CONDITIONING,
        CarOption::ALLOY_WHEELS,
        CarOption::ABS,
        CarOption::POWER_STEERING
    );

    public function testVehicleHasSetOption()
    {
        $vehicle = $this->createVehicle();
        $vehicle->setOptions($this->carOptions);

        $this->assertTrue($vehicle->hasOption(CarOption::AIR_CONDITIONING));
        $this->assertTrue($vehicle->hasOption(CarOption::ALLOY_WHEELS));
        $this->assertTrue($vehicle->hasOption(CarOption::ABS));
        $this->assertTrue($vehicle->hasOption(CarOption::POWER_STEERING));
    }

    public function testVehicleHasAllOptions()
    {
        $vehicle = $this->createVehicle();
        $vehicle->setOptions($this->carOptions);

        $this->assertTrue($vehicle->hasAllOptions(
            array(
                CarOption::AIR_CONDITIONING,
                CarOption::ALLOY_WHEELS
            )
        ));
    }

    public function testVehicleHasNotSetOption()
    {
        $vehicle = $this->createVehicle();
        $vehicle->setOptions($this->carOptions);

        $this->assertFalse($vehicle->hasOption(CarOption::CRUISE_CONTROL));
    }

    public function testVehicleHasNotAllOptions()
    {
        $vehicle = $this->createVehicle();
        $vehicle->setOptions($this->carOptions);

        $this->assertFalse($vehicle->hasAllOptions(
            array(
                CarOption::AIR_CONDITIONING,
                CarOption::ALLOY_WHEELS,
                CarOption::TOWBAR
            )
        ));
    }

    public function createVehicle()
    {
        $vehicle = new Vehicle();
        $vehicle->setId(1)
            ->setLicensePlate('9XRX22')
            ->setCondition(VehicleCondition::GOOD)
            ->setDrivable(true)
            ->setDamageFree(true)
            ->setMakeName('CITROEN')
            ->setModelName('SAXO')
            ->setYearOfManufacture(2001)
            ->setFuelType('benzine')
            ->setMileage(113249)
            ->setNumberOfDoors(4)
            ->setBpm(1200)
            ->setFuelType(FuelUtils::GASOLINE);
        return $vehicle;
    }
}
